/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-07-09
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef CITYSCANNER_H
#define CITYSCANNER_H

#include <QGpCoreTools.h>

#include "DeviceCardScanner.h"
#include "GeopsyCoreDLLExport.h"

namespace GeopsyCore {

class CitySignal;

class GEOPSYCORE_EXPORT CityScanner: public DeviceCardScanner
{
  Q_OBJECT
public:
  CityScanner(QObject * parent=nullptr);
  ~CityScanner();

  bool setPath(const QDir& cardPath);
  virtual void clear();
  int count() {return _signals.count();}
  void erase();
  QString softwareVersion() const {return _softwareVersion;}
  const CitySignal * at(int index) const {return _signals.at(index);}
signals:
  void beginSignalChange();
  void endSignalChange();
protected:
  virtual void run();
  virtual QFile * stream(QIODevice::OpenModeFlag mode);
  void normalScan();
  QFile * fichbaseStream(QIODevice::OpenModeFlag mode);
  QFile * sectcityStream(QIODevice::OpenModeFlag mode);
private:
  void readSoftwareVersion();

  QDir _cardPath;
  QList<CitySignal *> _signals;
  QString _softwareVersion;
};

} // namespace GeopsyCore

#endif // CITYSCANNER_H
