/***************************************************************************
**
**  This file is part of GeopsyCore.
**
**  GeopsyCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  GeopsyCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-07-15
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "AbstractFileFormat.h"

namespace GeopsyCore {

/*!
  \class AbstractFileFormat AbstractFileFormat.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

  /*!
    Description of constructor still missing
  */
  AbstractFileFormat::AbstractFileFormat()
  {
    TRACE;
  }

  /*!
    Description of constructor still missing
  */
  AbstractFileFormat::AbstractFileFormat(const AbstractFileFormat& o)
    : XMLClass(), SharedObject(o)
  {
    TRACE;
    _name=o._name;
    _caption=o._caption;
    _suffixList=o._suffixList;
  }

  /*!
    Description of destructor still missing
  */
  AbstractFileFormat::~AbstractFileFormat()
  {
    TRACE;
  }

  void AbstractFileFormat::operator=(const AbstractFileFormat& o)
  {
    TRACE;
    SharedObject::operator=(o);
    _name=o._name;
    _caption=o._caption;
    _suffixList=o._suffixList;
  }

  /*!
    Add \a e to the list of accepted suffix. The first one is the default one.
  */
  void AbstractFileFormat::addSuffix(QString s)
  {
    TRACE;
    if(s.left(1)==".") {
      s=s.mid(1);
    }
    s=s.trimmed().toLower();
    if(!s.isEmpty()) {
      _suffixList << s;
    }
  }

  /*!
    Add extensions from a coma-separated list.
  */
  void AbstractFileFormat::addSuffixList(const QString& sl)
  {
    TRACE;
    QStringList sList=sl.split(",");
    foreach(QString s, sList) {
      addSuffix(s);
    }
  }

  /*!
    Returns all possible extensions as a filter string.
  */
  QString AbstractFileFormat::suffixFilter() const
  {
    TRACE;
    QString f;
    if(_suffixList.isEmpty()) {
      return "*";
    } else {
      foreach(QString s, _suffixList) {
        if(!f.isEmpty()) {
          f+=" ";
        }
        f+="*."+s;
      }
      return f;
    }
  }

  QString AbstractFileFormat::captionFilter() const
  {
    TRACE;
    QString filt=suffixFilter();
    if(filt=="*")
      return caption();
    else
      return QString("%1 (%2)").arg(caption()).arg(filt);
  }

  /*!
    Removes all spaces and quotes from name \n and set upper letters for first letters of each word.
    Format names may be used in command line.
  */
  void AbstractFileFormat::setName(QString n)
  {
    TRACE;
    QRegExp reg;
    reg.setPattern("\t\'\"");
    n.replace(reg, " ");
    QString standardName;
    reg.setPattern(" *([a-zA-Z])");
    int index=reg.indexIn(n, 0);
    standardName=reg.cap(0).toUpper();
    index+=reg.matchedLength();
    int lastIndex=index;
    reg.setPattern(" +\\b([a-zA-Z]?)");
    index=reg.indexIn(n, lastIndex);
    while(index>=0) {
      standardName+=n.mid(lastIndex, index-lastIndex);
      standardName+=reg.cap(1).toUpper();
      index+=reg.matchedLength();
      lastIndex=index;
      index=reg.indexIn(n, lastIndex);
    }
    standardName+=n.mid(lastIndex);
    _name=standardName;
  }

  void AbstractFileFormat::xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const
  {
    TRACE;
    Q_UNUSED(context)
    writeProperty(s, "name", _name);
    writeProperty(s, "extensions", _suffixList.join(","));
    writeProperty(s, "caption", _caption);
  }

  XMLMember AbstractFileFormat::xml_member(XML_MEMBER_ARGS)
  {
    TRACE;
    Q_UNUSED(context)
    Q_UNUSED(attributes)
    if(tag=="name") return XMLMember(0);
    else if(tag=="extensions") return XMLMember(1);
    else if(tag=="caption") return XMLMember(2);
    else return XMLMember(XMLMember::Unknown);
  }

  bool AbstractFileFormat::xml_setProperty(XML_SETPROPERTY_ARGS)
  {
    TRACE;
    Q_UNUSED(tag)
    Q_UNUSED(attributes)
    Q_UNUSED(context)
    switch(memberID) {
    case 0: _name=content.toString(); return true;
    case 1: {
        QString e=content.toString();
        if(!e.isEmpty()) {
          _suffixList=e.split(",");
        } else {
          _suffixList.clear();
        }
      }
      return true;
    case 2: _caption=content.toString(); return true;
    default:
      break;
    }
    return false;
  }

  bool AbstractFileFormat::load(SignalFile *) const
  {
    TRACE;
    return false;
  }

  bool AbstractFileFormat::load(const Signal *, double *) const
  {
    TRACE;
    return false;
  }

  bool AbstractFileFormat::save(const SubSignalPool&, const QString&) const
  {
    TRACE;
    return false;
  }


} // namespace GeopsyCore
