/***************************************************************************
**
**  This file is part of DinverGui.
**
**  DinverGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-04-10
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PARAMSPACEEDITOR_H
#define PARAMSPACEEDITOR_H

#include <DinverCore.h>

#include "ui_ParamSpaceEditor.h"
#include "DinverGuiDLLExport.h"

namespace DinverGui {

class DINVERGUI_EXPORT ParamSpaceEditor : public QWidget, private Ui::ParamSpaceEditor
{
  Q_OBJECT
public:
  ParamSpaceEditor(QWidget * parent=nullptr);

  ParamSpaceScript * script();
  QString text();
  void setFrom(const ParamSpaceScript * script);
  void setFrom(QString script);

  void setEditable(bool e);
signals:
  void check();
};

} // namespace DinverGui

#endif // PARAMSPACEEDITOR_H
