/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  DinverDCCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverDCCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-07-27
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "RefractionTarget.h"

namespace DinverDCCore {

/*!
  \class RefractionTarget RefractionTarget.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

const QString RefractionTarget::xmlRefractionTargetTag="RefractionTarget";

/*!
  Description of constructor still missing
*/
RefractionTarget::RefractionTarget()
    : Target()
{
  TRACE;
}

/*!
  Description of destructor still missing
*/
RefractionTarget::RefractionTarget(const RefractionTarget& o)
    : Target(o)
{
  TRACE;
  _curves=o._curves;
}

void RefractionTarget::setCurves(const QList<RefractionCurve>& c)
{
  TRACE;
  _curves=c;
  for(QList<RefractionCurve>::iterator it=_curves.begin(); it!=_curves.end(); it++) {
    it->sort();
  }
}

void RefractionTarget::xml_writeChildren(XML_WRITECHILDREN_ARGS) const
{
  TRACE;
  for(QList<RefractionCurve>::const_iterator it=_curves.begin(); it!=_curves.end(); ++it) {
    it->xml_save(s, context);
  }
}

XMLMember RefractionTarget::xml_member(XML_MEMBER_ARGS)
{
  TRACE;
  Q_UNUSED(context)
  if(tag=="RefractionCurve") {
    _curves.append(RefractionCurve());
    return XMLMember(&_curves.last());
  } else return Target::xml_member(tag, attributes, context);
}

} // namespace DinverDCCore
