/***************************************************************************
**
**  This file is part of DinverDCCore.
**
**  DinverDCCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverDCCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-07-27
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "AutocorrTarget.h"

namespace DinverDCCore {

/*!
  \class AutocorrTarget AutocorrTarget.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

const QString AutocorrTarget::xmlAutocorrTargetTag="AutocorrTarget";

/*!
  Description of constructor still missing
*/
AutocorrTarget::AutocorrTarget()
    : Target()
{
  TRACE;
  // The default was not L2 before 20100307...
  //           L2_Normalized until 20100324
  // In fact what's better for SPAC is L2_NormalizedBySigmaOnly
  // This means: normalized by standard deviation and do not normalize by average data value
  //             if there is no standard deviation (because SPAC may have very small values).
  setMisfitType(L2_NormalizedBySigmaOnly);
}

/*!
  Description of constructor still missing
*/
AutocorrTarget::AutocorrTarget(const AutocorrTarget& o)
    : Target(o)
{
  TRACE;
  _curves=o._curves;
}

void AutocorrTarget::setCurves(const AutocorrCurves& c)
{
  TRACE;
  _curves=c;
}


void AutocorrTarget::xml_writeChildren(XML_WRITECHILDREN_ARGS) const
{
  TRACE;
  _curves.xml_save(s, context);
}

XMLMember AutocorrTarget::xml_member(XML_MEMBER_ARGS)
{
  TRACE;
  Q_UNUSED(context)
  if(tag=="AutocorrCurves") {
    return XMLMember(&_curves);
  } else return Target::xml_member(tag, attributes, context);
}

bool AutocorrTarget::xml_polish(XML_POLISH_ARGS)
{
  Q_UNUSED(context)
  // Force L2_NormalizedBySigmaOnly and ignore value read from file
  setMisfitType(L2_NormalizedBySigmaOnly);
  return true;
}

} // namespace DinverDCCore
