/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-12-20
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef REPORTWRITER_H
#define REPORTWRITER_H

#define REPORT_FILE_TAG "DINVER05"
#define REPORT_BLOCK_TAG "MBLK"

#define REPORT_CURRENT_VERSION 1

#include <QGpCoreTools.h>
#include "DinverCoreDLLExport.h"

namespace DinverCore {

class Parameter;
class RealSpace;

class DINVERCORE_EXPORT ReportWriter
{
  TRANSLATIONS("ReportWriter")
public:
  ReportWriter(QString fileName) : _f(fileName) {_blockOffset=0;}
  ~ReportWriter() {}

  enum Action {Ask, Overwrite, Append};
  static bool initReport(const QString& fileName, const QString& title, Action action);

  bool open();
  void close();

  QDataStream& stream() {return _s;}
  bool isOpen() {return _f.isOpen();}
  void addModel(double misfit, uint paramChecksum, int nd, Parameter ** model);
  void addModel(double misfit, uint paramChecksum, const RealSpace& parameterSpace);
  inline void userBlockHeader(const char * tag, int version);
  static void setCurrentOffset(QDataStream& s, qint64 tableOffset);
  static void setEmptyOffset(QDataStream& s, qint64 tableOffset);
  static void remove(const QString& fileName);
private:
  QFile _f;
  QDataStream _s;

  qint64 _blockOffset;
};

inline void ReportWriter::userBlockHeader(const char * tag, int version)
{
  TRACE;
  _s.writeRawData(tag,4);
  _s << version;
}

} // namespace DinverCore

#endif // REPORTWRITER_H
