/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-12-22
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GENERATORMODELS_H
#define GENERATORMODELS_H

#include <QGpCoreTools.h>

#include "DinverCoreDLLExport.h"
#include "Index.h"

namespace DinverCore {

  class BestModels;
  class ActiveModels;
  class ScaledModels;
  class ModelSet;
  class RealSpace;
  class NewModel;

  class DINVERCORE_EXPORT GeneratorModels: public SharedObject
  {
  public:
    GeneratorModels(ModelSet * allModels);
    GeneratorModels(const GeneratorModels& o);
    ~GeneratorModels();

    const ActiveModels * activeModels() const {return _activeModels;}
    const BestModels * bestModels() const {return _bestModels;}
    BestModels * bestModels() {return _bestModels;}
    const ScaledModels * scaledModels() const {return _scaledModels;}
    int serialNumber() const {return _serialNumber;}

    void setBestModelCount(int nr);
    void setScaledModels(const RealSpace& parameterSpace);
    GeneratorModels * removeDeadModels() const;
    void clear();

    void commitStatistics(NewModel * m, double giveUp);
    void add(const SetIndex& index, double parentVolume);

    int rejectedCount() const {return _rejectedCount;}
    int giveUpCount() const {return _giveUpCount;}
    int atomicCount() const {return _atomicCount;}
  private:
    int _serialNumber;
    static int _nextSerialNumber;

    BestModels * _bestModels;
    ActiveModels * _activeModels;
    ScaledModels * _scaledModels;

    int _giveUpCount;
    int _rejectedCount;
    int _atomicCount;
  };

} // namespace DinverCore

#endif // GENERATORMODELS_H
