/***************************************************************************
**
**  This file is part of DinverCore.
**
**  DinverCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  DinverCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-05-06
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef BESTMODELS_H
#define BESTMODELS_H

#include "DinverCoreDLLExport.h"
#include "ActiveModels.h"

namespace DinverCore {

  class DINVERCORE_EXPORT BestModels : private IncreaseStorage
  {
  public:
    BestModels(ActiveModels * models);
    BestModels(const BestModels& o, ActiveModels * models);
    BestModels(const BestModels& o);
    ~BestModels();

    void print() const;

    void setModels(ActiveModels * models) {_models=models;}
    void setNr(int nr);
    void update();
    void add(const ActiveIndex& index);
    void setIndex(const BestIndex& b, const ActiveIndex& a) {_indexes[b.value()]=a;}
    void remove(const ActiveIndex& index);
    void clear();

    void reserve(int n) {IncreaseStorage::reserve(n);}
    int count() const {return size();}
    inline  bool isSaturated() const;
    const ActiveIndex& activeIndex(const BestIndex& i) const {return _indexes[i.value()];}
    inline double misfit(const BestIndex& i, const TargetIndex& t) const;
    const int * model(const BestIndex& i) const {return _models->model(_indexes[i.value()]);}

    BestIndex * activeModelMap() const;
    BestIndex * allModelMap() const;
    const ActiveIndex& randomIndex(double randomValue) const;
    double averageVolume() const;
  private:
    virtual void reallocate();
    BestIndex indexOf(double m) const;
    BestIndex exactIndexOf(const ActiveIndex& index, double m, const BestIndex& approxIndex) const;
    inline void add();

    ActiveModels * _models;
    ActiveIndex * _indexes;
    int _nrMax, _nr2;
  };

  inline void BestModels::add()
  {
    IncreaseStorage::add();
    while(_nr2<size()) _nr2=_nr2 << 1;
  }

  inline double BestModels::misfit(const BestIndex& i, const TargetIndex& t) const
  {
    return _models->misfit(_indexes[i.value()], t);
  }

  inline  bool BestModels::isSaturated() const
  {
    BestIndex bBegin, bEnd;
    bEnd.setValue(count()-1);
    return count()>0 && misfit(bBegin, TargetIndex::first)==misfit(bEnd, TargetIndex::first);
  }

} // namespace DinverCore

#endif // BESTMODELS_H
