/***************************************************************************
**
**  This file is part of ArrayGui.
**
**  ArrayGui is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayGui is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-05-26
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef ARRAYRESPONSE_H
#define ARRAYRESPONSE_H

#include <ArrayCore.h>
#include <QGpGuiWave.h>

#include "WaveNumAnimate.h"
#include "ArrayGuiDLLExport.h"

namespace ArrayGui {

class ARRAYGUI_EXPORT ArrayResponse : public GraphicSheetMenu
{
  Q_OBJECT
public:
  ArrayResponse(QWidget *parent=nullptr, Qt::WindowFlags f=Qt::Widget);
  ~ArrayResponse();

  void setArray(const QVector<Point2D>& p);
  void setKmaxThreshold(double t) {_kmaxThreshold=t;}
  void setFrequencySampling(const SamplingParameters& fparam);
  void createObjects(bool showDispersion);
  double kmin() const;
  double kmax() const;

  double arraySize() const;
public slots:
  void setKmin(double kmin);
  void setKmax(double kmax);
  void setAzimuth(double azimuth);
private slots:
  void setTemporaryKmax();
  void setComputedKmax();
signals:
  void kminChanged(double kmin);
  void kmaxChanged(double kmin);
private:
  void initKmax(double kmax);
  void uniquePoints();
  void shiftStations();
  double theoreticalKmax() const;
  double gridKmax() const;
  double gridKmin() const;
  void scanAzimuth();
  virtual void resizeEvent(QResizeEvent *);

  LiveGridLayer * _gridLayer;
  CircleViewer * _circleLayer;
  LineLayer * _directionLayer;
  XUniqueYColorLines * _crossGrayLayer;
  LineLayer * _midHeightLayer;
  LineLayer * _crossBlackLayer;
  DispersionLimitLayer * _dispLimitLayer;
  DispersionLimitLayer * _dispLambdaLayer;

  double _kmin;
  QTimer _kmaxTimer;
  bool _kmaxTouched;
  double _kmaxThreshold;
  KmaxSolver * _kmaxSolver;

  TextEdit * _comments;

  WaveNumAnimate waveNum;
  ColorMapWidget _palette;
  LegendWidget * _lambdaLegend;

  QVector<Point2D> _stations;
  QVector<Complex> _stationSig;
};

} // namespace ArrayGui

#endif // ARRAYRESPONSE_H
