/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-11-10
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef SPACPEAKS_H
#define SPACPEAKS_H

#include "ArrayCoreDLLExport.h"
#include "SPACResults.h"

namespace ArrayCore {

  class SPACParameters;
  class ArraySelection;

  class ARRAYCORE_EXPORT SPACPeaks : private IncreaseStorage
  {
  public:
    SPACPeaks();
    ~SPACPeaks();

    class Value
    {
    public:
      double frequency;
      double time;
      Mode::Polarization polarization;
      int ring;
      double autocorr;
      bool valid;
    };

    void clear();
    int size() const {return IncreaseStorage::size();}

    bool add(Mode::Polarization polarization, const SPACResults::ValueInfo& info,
             int ring, double autocorr);
    void add(const SPACPeaks& peaks);
    void sort();
    void setTimeReference(const DateTime& t) {_timeReference=t;}
    bool save(const QString &fileName,
              const SPACParameters& param,
              const ArraySelection& array,
              const QString& log) const;

    static const char * maxHeaderLine;
  private:
    void reallocate();
    static bool valueLessThan(Value * v1, Value * v2);

    Value * _values;
    DateTime _timeReference;
    bool _full;
    Mutex _addLock;
    ReadWriteLock _dataLock;
  };

} // namespace ArrayCore

#endif // SPACPEAKS_H

