/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-04-12
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef ASYNCSTATIONPAIR_H
#define ASYNCSTATIONPAIR_H

#include <QGpCoreMath.h>

#include "ArrayCoreDLLExport.h"

namespace ArrayCore {

  class ArrayStationSignals;

  class ARRAYCORE_EXPORT AsyncStationPair
  {
  public:
    AsyncStationPair();
    ~AsyncStationPair();

    inline void setStation1(int index, ArrayStationSignals *station);
    inline void setStation2(int index, ArrayStationSignals *station);

    int index1() const {return _index1;}
    int index2() const {return _index2;}

    ArrayStationSignals * station1() const {return _station1;}
    ArrayStationSignals * station2() const {return _station2;}

    void addCrossSpectrum(const GaussianFrequencyBand& f, QString prefix);
    Complex mean(int component);
    double stddev(int component);
  private:
    int _index1, _index2;
    ArrayStationSignals *_station1, *_station2;
    Complex * _sum;
    double * _sum2;
    int _count;
  };

  inline void AsyncStationPair::setStation1(int index, ArrayStationSignals *station)
  {
    _index1=index;
    _station1=station;
  }

  inline void AsyncStationPair::setStation2(int index, ArrayStationSignals *station)
  {
    _index2=index;
    _station2=station;
  }

} // namespace ArrayCore

#endif // ASYNCSTATIONPAIR_H

