/***************************************************************************
**
**  This file is part of ArrayCore.
**
**  ArrayCore is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  ArrayCore is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2018-10-04
**  Copyright: 2018-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "FKGridSearch.h"
#include "ActiveHRFKRayleighEllipticity.h"

namespace ArrayCore {

  /*!
    \class ActiveHRFKRayleighEllipticity ActiveHRFKRayleighEllipticity.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  void ActiveHRFKRayleighEllipticity::setGrid(FKGridSearch * g, double step, double size)
  {
    g->setGrid(-size, size, step);
  }

  double ActiveHRFKRayleighRadialEllipticity::value(const Point& ell) const
  {
    ComplexMatrix e, eh;
    //_gridCache->activeTwoComponentRayleighRadial(*_steeringGeometry, _k, ::tan(ell.x()), e, eh);
    //return caponPower(eh, *_crossSpectrum, e);
  }

  double ActiveHRFKRayleighVerticalEllipticity::value(const Point& ell) const
  {
    ComplexMatrix e, eh;
    //_gridCache->activeTwoComponentRayleighVertical(*_steeringGeometry, _k, ::tan(ell.x()), e, eh);
    //return caponPower(eh, *_crossSpectrum, e);
  }

  double ActiveConvFKRayleighRadialEllipticity::value(const Point& ell) const
  {
    ComplexMatrix e, eh;
    //_gridCache->activeTwoComponentConvRayleighRadial(*_steeringGeometry, _k, ::tan(ell.x()), e, eh);
    //return 1.0/conventionalPower(eh, *_crossSpectrum, e);
  }

  double ActiveConvFKRayleighVerticalEllipticity::value(const Point& ell) const
  {
    ComplexMatrix e, eh;
   // _gridCache->activeTwoComponentConvRayleighVertical(*_steeringGeometry, _k, ::tan(ell.x()), e, eh);
    //return 1.0/conventionalPower(eh, *_crossSpectrum, e);
  }

} // namespace ArrayCore

