/***************************************************************************
**
**  This file is part of waran.
**
**  waran is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  waran is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2011-09-05
**  Copyright: 2011-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef STATIONITEM_H
#define STATIONITEM_H

#include <QtGui>

class Station;

class StationItem : public QAbstractTableModel
{
  Q_OBJECT
public:
  StationItem(QObject * parent=nullptr);
  ~StationItem();

  void setStations(QList<Station *> * stations);

  virtual int rowCount(const QModelIndex& parent) const;
  virtual int	columnCount(const QModelIndex& parent) const;
  virtual QVariant data(const QModelIndex & index, int role) const;
  virtual QVariant headerData(int section, Qt::Orientation orientation, int role) const;
  Qt::ItemFlags flags(const QModelIndex& index) const;
private slots:
  void stationChanged(int stationIndex);
private:
  QList<Station *> * _stations;
  QSet<int> _toUpdate;
  QElapsedTimer _lastUpdate;
};

#endif // STATIONITEM_H
