/***************************************************************************
**
**  This file is part of spac2disp.
**
**  spac2disp is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  spac2disp is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-06-07
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SpacSelector_H
#define SpacSelector_H

#include <QGpCoreWave.h>
#include <QGpGuiMath.h>

class Spac2DispOptions;

class SpacSelector : public GraphicSheetMenu
{
  Q_OBJECT
public:
  SpacSelector(QWidget * parent=nullptr);
  ~SpacSelector();
  bool createObjects(AutocorrCurves * autocorr);
  Spac2DispOptions * options;
  CurveBrowser * curves;

  void loadCurves(const QString& fileName, const QString& parserFileName);
  void exportPlot(const ExportOptions& o);
  void setLimits();
  void setMaximumSolutionCount(int c) {_maxSolutionCount=c;}
  void setCellCount(int c);
  void setVelocityRange(double vmin, double vmax);
  void setWavenumberRange(double kmin, double kmax);
  void adjustCurve(CurveProperties * properties, double min=0.0, double max=0.0, SamplingOptions options=LinearScale);
public slots:
  void setK();
  void inverse();
  void inverseAt();
  void selectSamples();
  void saveSelection();
  void radiusScroll_valueChanged();
  void autoPick();
  void adjustCurve();
protected:
  virtual void closeEvent(QCloseEvent *);
private:
  Curve<Point2D>& limitsSolutionsCurve(int index);
  void adjustCurve(ModalCurve& curve, double min, double max, SamplingOptions options);
  void invalidateRangeK(ModalCurve& curve);

  AutocorrCurves * _autocorr;
  AutocorrCurves * _selAutocorr;
  int _lastCurRing;
  int _maxSolutionCount;
  IrregularGrid2DPlot * _gridLayer;
  LineLayer * _limitsSolutionsLayer;
  QVector<LineLayer *> _spacLayers;
};

#endif
