/***************************************************************************
**
**  This file is part of phaseit.
**
**  phaseit is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  phaseit is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-12-07
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef TOOL_H
#define TOOL_H

#include <GeopsyCore.h>

#include "Parameters.h"

class TimeLoop;
class TaskManager;

class Tool : public AbstractTool
{
public:
  Tool(QObject * parent);
  ~Tool();

  bool setSubPool(SubSignalPool * subPool);

  bool setParameters(const AbstractParameters& param);
  inline const Parameters * parameters() const;
  inline Parameters * parameters();

  int referenceStation() const;

  void autoWindows();
  void inverseWindows();
  void addWindows(const TimeRange& r);
  void removeWindows(const TimeRange& r);
  void clearWindows();
  bool loadWindows(QString fileName);

  int componentCount() const {return _stations.nComponents();}
  Signal::Components component(int index) {return _stations.component(index);}

  int stationCount() const {return _stations.count();}
  const StationSignals * station(int index) {return _stations.at(index);}

  const TimeWindowList& timeWindows() const {return _timeWindows;}

  const TaskManager * loop() const;
protected:
  ParallelTaskManager * createLoop();
private:
  SparseKeepSignal * globalKeep(const TimeRange& r, const WindowingParameters& param);

  StationList _stations;
  TimeWindowList _timeWindows;
  TimeLoop * _loop;
};

inline const Parameters * Tool::parameters() const
{
  return static_cast<const Parameters *>(AbstractTool::parameters());
}

inline Parameters * Tool::parameters()
{
  return static_cast<Parameters *>(AbstractTool::parameters());
}

#endif // TOOL_H

