/***************************************************************************
**
**  This file is part of phaseit.
**
**  phaseit is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  phaseit is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-12-07
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "Tool.h"
#include "TaskManager.h"

/*!
  \class Tool Tool.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
Tool::Tool(QObject * parent)
  : AbstractTool(parent)
{
  TRACE;
  AbstractTool::setParameters(Parameters());
  _stations.setComponents(StationSignals::AnySingleComponent);
}

/*!
  Description of destructor still missing
*/
Tool::~Tool()
{
  TRACE;
}

bool Tool::setSubPool(SubSignalPool * subPool)
{
  TRACE;
  if(!AbstractTool::setSubPool(subPool)) {
    return false;
  }
  App::log("*********** "+subPool->name()+" ***********\n");
  StationSignals::organizeSubPool(subPool);
  if(!_stations.addSignals(subPool)) {
    return false;
  }
  if(_stations.count()<2) {
    App::log(tr("Found less than 2 signals.\n"));
    return false;
  }
  App::log(tr("Found %1 distinct signals\n").arg(_stations.count()));
  return true;
}

/*!
  Allocate a new global keep vector (ready to add time windows)
*/
SparseKeepSignal * Tool::globalKeep(const TimeRange& r, const WindowingParameters& param)
{
  TRACE;
  // Collect ranges for all stations
  SparseTimeRange sr(r);
  int n=_stations.count();
  for(int i=0; i<n; i++) {
    sr=sr.intersection(_stations[i]->timeRange(r));
  }
  SparseKeepSignal * keep=new SparseKeepSignal(sr);
  // Adjust range taking sampling of all stations into account
  for(int i=0; i<n; i++) {
    _stations[i]->setSampling(keep);
  }
  // Set values of keep
  keep->initValues(1);
  for(int i=0; i<n; i++) {
    _stations[i]->setKeep(keep, param, i);
  }
  return keep;
}

void Tool::autoWindows()
{
  TRACE;
  TimeRange r=parameters()->timeRange().absoluteRange(subPool());
  SparseKeepSignal * keep=globalKeep(r, parameters()->windowing());
  _timeWindows.clear();
  _timeWindows.add(1.0, parameters()->windowing(), *keep, r);
  delete keep;
}

void Tool::inverseWindows()
{
  TRACE;
  TimeRange r=parameters()->timeRange().absoluteRange(subPool());
  SparseKeepSignal * keep=globalKeep(r, parameters()->windowing());
  _timeWindows.inverse(1.0, parameters()->windowing(), *keep, r);
  delete keep;
}

void Tool::addWindows(const TimeRange& r)
{
  TRACE;
  // Do not use r for the computation of keep, because r can be shorter than lta
  // which generate a selection that depends upon the length of signal selected.
  SparseKeepSignal * keep=globalKeep(parameters()->timeRange().absoluteRange(subPool()),
                                     parameters()->windowing());
  if(_timeWindows.isEmpty()) {
    _timeWindows.add(1.0, parameters()->windowing(), *keep, r);
  } else {
    _timeWindows.addBlanks(1.0, parameters()->windowing(), *keep, r);
  }
  delete keep;
}

void Tool::removeWindows(const TimeRange& r)
{
  TRACE;
  _timeWindows.remove(r);
}

void Tool::clearWindows()
{
  TRACE;
  _timeWindows.clear();
}

bool Tool::loadWindows(QString fileName)
{
  TRACE;
  return true;
}

bool Tool::setParameters(const AbstractParameters& param)
{
  const Parameters * myParam=dynamic_cast<const Parameters *>(&param);
  if(!myParam) {
    qDebug() << "Parameters are not Parameters in Tool::setParameters.";
    return false;
  }
  if(!AbstractTool::setParameters(param)) {
    return false;
  }
  if(!parameters()->isValid(_stations.count())) {
    return false;
  }
  // At this step parameters are fine and they will be no longer modified
  return setLoop();
}

ParallelTaskManager * Tool::createLoop()
{
  TaskManager * tm=new TaskManager(&_stations);
  tm->setTimeWindows(&_timeWindows);
  tm->setParameters(parameters());
  tm->setTasks();
  return tm;
}

const TaskManager * Tool::loop() const
{
  return static_cast<const TaskManager *>(AbstractTool::loop());
}

