/***************************************************************************
**
**  This file is part of phaseit.
**
**  phaseit is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  phaseit is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-07-01
**  Copyright: 2016
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "ProcessSignals.h"
#include "Parameters.h"

/*!
  \class ProcessSignals ProcessSignals.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
ProcessSignals::ProcessSignals(const StationSignals * originalSignals)
  : StationProcessSignals(originalSignals)
{
  TRACE;
}

/*!
  Description of destructor still missing
*/
ProcessSignals::~ProcessSignals()
{
  TRACE;
}

bool ProcessSignals::setProcessed(const TimeRange& tw, const AbstractParameters *)
{
  TRACE;
  if(!copyOriginalSignal(0, tw)) {
    return false;
  }
  DoubleSignal *& psig=processed(0);
  psig->subtractValue();
  WindowFunctionParameters tp;
  tp.setShape(WindowFunctionParameters::Tukey);
  tp.setAlpha(0.05);
  psig->taper(0.0, tw.lengthSeconds(), tp);
  return true;
}

