/***************************************************************************
**
**  This file is part of max2curve.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2005-10-27
**  Authors:
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef STATGRIDANALYSER_H
#define STATGRIDANALYSER_H

#include <SciFigs.h>
#include <QGpCoreTools.h>

#include "ui_StatGridAnalyser.h"

class StatGridAnalyser : public QWidget, public Ui::StatGridAnalyser
{
  Q_OBJECT
public:
  StatGridAnalyser(QWidget *parent=0, Qt::WindowFlags f=0);
  ~StatGridAnalyser();

  void setUnits(const QString& u) {_units=u;}
  void setGrid(IrregularGrid2DPlot * grid, Axis * valueAxis);
public slots:
  void gridChanged();
  void on_freqScroll_valueChanged(int);
  void on_rejectBut_clicked();
  void on_undoBut_clicked();
  void on_rejectAllBut_clicked();
  void on_undoAllBut_clicked();
  void setBand(double min, double max);
private:
  enum Shortcuts {NextFrequency, NextFrequencyReject,
                   PreviousFrequency, PreviousFrequencyReject,
                   IncreaseLowLimit, IncreaseHighLimit,
                   DecreaseLowLimit, DecreaseHighLimit};
private slots:
  void nextFrequency() {shortcutEvents(NextFrequency);}
  void nextFrequencyReject() {shortcutEvents(NextFrequencyReject);}
  void previousFrequency() {shortcutEvents(PreviousFrequency);}
  void previousFrequencyReject() {shortcutEvents(PreviousFrequencyReject);}
  void increaseLowLimit() {shortcutEvents(IncreaseLowLimit);}
  void increaseHighLimit() {shortcutEvents(IncreaseHighLimit);}
  void decreaseLowLimit() {shortcutEvents(DecreaseLowLimit);}
  void decreaseHighLimit() {shortcutEvents(DecreaseHighLimit);}
signals:
  void reject(double frequency, double minVel, double maxVel);
  void undo(double frequency);
  void newMean();
  void newMedian();
  void newMode();
private:
  void setRejectBand(int nextFreq);
  virtual void closeEvent(QCloseEvent *e) {e->ignore();}
  void shortcutEvents(Shortcuts s);

  IrregularGrid2DPlot * _grid;
  Axis * _valueAxis;
  QString _units;
  int _lastFreq;
  QVector< QPair<double, double> > _bands;
  ParallelBands * _partitionBandLayer;
  LineLayer * _partitionCurveLayer;
  ParallelBands * _densityBandLayer;
  LineLayer * _densityCurveLayer;
};

#endif // QTBSTATGRIDANALYSER_H
