/***************************************************************************
**
**  This file is part of matfiles.
**
**  This file may be distributed and/or modified under the terms of the
**  GNU General Public License version 2 or 3 as published by the Free
**  Software Foundation and appearing in the file LICENSE.GPL included
**  in the packaging of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU General Public License for
**  more details.
**
**  You should have received a copy of the GNU General Public License
**  along with this program. If not, see <http://www.gnu.org/licenses/>.
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2013-11-21
**  Authors:
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef MATREADER_H
#define MATREADER_H

#ifndef GP_MATLAB_LIBS

#include <QGpCoreTools.h>

class MatContext;

class MatReader
{
public:
  MatReader(MatContext * context);
  ~MatReader();

  bool read(const QString& fileName);
  static bool isValidHeader(const QString& fileName);
private:
  bool parse(QDataStream& s);
  bool parseCompressed(QDataStream& s, uint dataSize);
  bool parseMatrix(QDataStream& s, uint dataSize);
  bool parseUtf8(QDataStream& s, uint dataSize);
  bool parseUtf16(QDataStream& s, uint dataSize);
  bool parseUtf32(QDataStream& s, uint dataSize);

  MatContext * _context;
};

#endif // GP_MATLAB_LIBS

#endif // MATREADER_H
