/***************************************************************************
**
**  This file is part of hvtfa.
**
**  hvtfa is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  hvtfa is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-02-07
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**    Miriam Kristekova (Geophysical Institute, Academy of Sciences, Bratislava, Slovak Republic)
**
***************************************************************************/

#ifndef HVTFALOOP_H
#define HVTFALOOP_H

#include <GeopsyCore.h>

class HVTFAParameters;

class HVTFALoop: public ParallelLoop
{
public:

  bool openMaxFile(bool createNew);

  QString _stationName;
  const HVTFAParameters * _param;
  DoubleSignal * _signals[3];
  mutable Mutex _dotmaxMutex;
  mutable QFile _fdotmax;
  DateTime _startTime;
  double _samplingPeriod;
  double _sampFreq;
  SignalDatabase * _database;
protected:
  virtual LoopWorker * newWorker();
};

class HVTFALoopWorker: public LoopWorker
{
public:
  void setLoop(const HVTFALoop * l) {_loop=l;}
protected:
  virtual void run(int index);
private:
  const HVTFALoop * _loop;

  static inline int nextMaximum(const Curve<Point2D>& curve, int iStart, int iEnd);
};

#endif // HVTFALOOP_H
