/***************************************************************************
**
**  This file is part of gpmodel2param.
**
**  gpmodel2param is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpmodel2param is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-12-15
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <DinverCore.h>
#include <DinverDCCore.h>
#include <QGpCoreTools.h>
#include <QGpCoreWave.h>
#include "Model2ParamReader.h"

/*!
  \class Model2ParamReader Model2ParamReader.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
Model2ParamReader::Model2ParamReader()
    : ArgumentStdinReader()
{
  TRACE;
  _outputParam="out.param";
  _vsRelativeRange=0.0;
}

bool Model2ParamReader::setOptions(int& argc, char ** argv)
{
  TRACE;
  // Check arguments
  int i, j=1;
  for(i=1; i<argc; i++) {
    QByteArray arg=argv[i];
    if(arg[0]=='-') {
      if(arg=="-o") {
        CoreApplication::checkOptionArg(i, argc, argv);
        _outputParam=argv[i];
      } else if (arg=="-vs-relative-range") {
        CoreApplication::checkOptionArg(i, argc, argv);
        _vsRelativeRange=CoreApplication::toDouble(i, i-1, argv);
      } else {
        App::log(tr("gpmodel2param: bad option %1, see -help\n").arg(argv[i]) );
        return false;
      }
    } else {
      argv[j++]=argv[i];
    }
  }
  if(j < argc) {
    argv[j]=nullptr;
    argc=j;
  }
  return true;
}

bool Model2ParamReader::parse(QTextStream& s)
{
  TRACE;
  QTextStream sOut(stdout);
  Seismic1DModel m;
  QString comments;
  if(!m.fromStream(s, &comments)) {
    return false;
  }
  if(m.layerCount()>0) {
    QFileInfo fi(_outputParam);
    if(fi.exists()) {
      App::log(tr("File %1 already exists.\n").arg(_outputParam) );
      return false;
    }
    ParamGroundModel gm(&m);
    if(_vsRelativeRange>0.0) {
      ParamProfile * vs=gm.find("Vs");
      for(int i=vs->nLayers()-1; i>=0; i++) {
        ParamLayer * l=vs->layer(i);
        double v=l->topMinimumValue();
        l->setTopMinimumValue(v*(1.0-_vsRelativeRange));
        l->setTopMaximumValue(v*(1.0+_vsRelativeRange));
      }
    }
    XMLVirtualPlugin plugin(&gm, "DispersionCurve");
    XMLDinverHeader hdr(&plugin);
    hdr.xml_saveFile(_outputParam);
  }
  return true;
}

