/***************************************************************************
**
**  This file is part of gpgroup2phase.
**
**  gpgroup2phase is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpgroup2phase is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-03-27
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>
#include "Group2PhaseReader.h"
#include "gpgroup2phaseVersion.h"
#include "gpgroup2phaseInstallPath.h"

PACKAGE_INFO("gpgroup2phase", GPGROUP2PHASE)

ApplicationHelp * help();
void scanCurve(Curve<Point2D>& groupCurve);
Curve<Point2D> phase(const Curve<Point2D>& groupCurve, double s1, double s2);
Curve<Point2D> group(const Curve<Point2D>& phaseCurve);

int main(int argc, char ** argv)
{
  CoreApplication a(argc, argv, help);

  Group2PhaseReader reader;
  if(reader.setOptions(argc, argv) && reader.read(argc, argv) ) {
    return 0;
  } else {
    return 2;
  }
}

ApplicationHelp * help()
{
  ApplicationHelp * h=new ApplicationHelp;
  h->setOptionSummary( "[OPTIONS] [FILE]..." );
  h->setComments( "Convert a group dispersion curve given by FILEs or by stdin into phase dispersion curves..");
  h->addGroup("Gpgroup2phase","gpgroup2phase");
  h->addOption("-g2p","Convert from group to phase velocity (default mode).");
  h->addOption("-p2g","Convert from phase to group velocity.");
  return h;
}
