/***************************************************************************
**
**  This file is part of gpgridsearch.
**
**  gpgridsearch is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  gpgridsearch is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-04-25
**  Copyright: 2016-2019

**
***************************************************************************/

#include "Reader.h"
#include "gpgridsearchVersion.h"
#include "gpgridsearchInstallPath.h"

PACKAGE_INFO("gpgridsearch", GPGRIDSEARCH)

ApplicationHelp * help();

int main(int argc, char ** argv)
{
  CoreApplication a(argc, argv, help);
  App::setPrefix("gpgridsearch: ");

  // Options
  Reader reader;
  if(reader.setOptions(argc, argv)) {
    if(reader.read(argc, argv)) {
      reader.run();
      return 0;
    } else {
      return 2;
    }
  } else {
    return 2;
  }
}

ApplicationHelp * help()
{
  TRACE;
  ApplicationHelp * h=new ApplicationHelp;
  h->setOptionSummary( "[OPTIONS]");
  h->setComments("Grid search of dispersion curves (and similar targets).");
  h->addGroup("gpgridsearch", "gpgridsearch");
  h->addOption("-target <TARGET>","Set targets from file TARGET. It can be a .target or a .dinver file. A .dinver file contains both parameters and "
                                  "targets. Provide it to both options '-param' and '-target'.");
  h->addOption("-param <PARAM>","Set parameters from file PARAM. It can be a .param or a .dinver file. A .dinver file contains both parameters and "
                                  "targets. Provide it to both options '-param' and '-target'.");
  h->addOption("-o <FILE>","Set the output report.");
  return h;
}
