/***************************************************************************
**
**  This file is part of geopsyhv.
**
**  geopsyhv is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsyhv is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2007-08-23
**  Copyright: 2007-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef SPECTRUMRESULTSHEET_H
#define SPECTRUMRESULTSHEET_H

#include <HVGui.h>

class SpectrumResultSheet : public CurveResultSheet
{
  Q_OBJECT
public:
  SpectrumResultSheet(QWidget* parent=0);
  ~SpectrumResultSheet();

  virtual void setWindowTitle(QString subPoolName);
  virtual void addActions();
protected slots:
  void derivate();
  void integrate();
  void loadResults();
protected:
  QString fileSuffix() {return ".spec";}
  AbstractResultWidget * createWidget();
};

#endif // SPECTRUMRESULTSHEET_H
