/***************************************************************************
**
**  This file is part of geopsydamping.
**
**  geopsydamping is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsydamping is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2012-03-24
**  Copyright: 2012-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include "Parameters.h"

/*!
  \class Parameters Parameters.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
Parameters::Parameters()
  : AbstractParameters()
{
  _filter=0;
}

/*!
  Description of constructor still missing
*/
Parameters::Parameters(const Parameters& o)
  : AbstractParameters()
{
  if(o._filter) {
    _filter=new FilterParameters(*o._filter);
  } else {
    _filter=0;
  }
}

/*!
  Description of destructor still missing
*/
Parameters::~Parameters()
{
  delete _filter;
}

const FilterParameters& Parameters::filter() const
{
  TRACE;
  ASSERT(_filter);
  return *_filter;
}

FilterParameters& Parameters::filter()
{
  TRACE;
  if(!_filter) {
    _filter=new FilterParameters;
  }
  return *_filter;
}

void Parameters::setFilter(const FilterParameters& f)
{
  TRACE;
  if(_filter) {
    *_filter=f;
  } else {
    _filter=new FilterParameters(f);
  }
}

QString Parameters::toString(PARAMETERS_TOSTRING_ARGS_IMPL) const
{
  TRACE;
  QString log;
  if(isFilter()) {
    log+=prefix+"DO FILTER"+suffix+"=y\n";
    log+=_filter->toString(prefix);
  } else {
    log+=prefix+"DO FILTER"+suffix+"=n\n";
  }
  log+=_timeRange.toString(prefix);
  log+="WINDOW LENGTH"+suffix+"="+QString::number(_windowLength)+"\n";
  log+="FIT LENGTH"+suffix+"="+QString::number(_fitLength)+"\n";
  return log;
}

int Parameters::keywordCount(PARAMETERS_KEYWORDCOUNT_ARGS) const
{
  return 3+AbstractParameters::keywordCount();
}

void Parameters::collectKeywords(PARAMETERS_COLLECTKEYWORDS_ARGS)
{
  TRACE;
  int baseIndex=AbstractParameters::keywordCount();
  keywords.add(prefix+"DO FILTER"+suffix, this, baseIndex);
  keywords.add(prefix+"WINDOW LENGTH"+suffix, this, baseIndex+1);
  keywords.add(prefix+"FIT LENGTH"+suffix, this, baseIndex+2);
  _timeRange.collectKeywords(keywords, prefix, suffix);
  if(isFilter()) {
    _filter->collectKeywords(keywords, prefix, suffix);
  }
}

bool Parameters::setValue(PARAMETERS_SETVALUE_ARGS)
{
  TRACE;
  switch(index-AbstractParameters::keywordCount()) {
  case 0:
    if(value=="y" ||
       value=="true") {  // For compatibility
      if(!_filter) {
        _filter=new FilterParameters;
      }
    }
    return true;
  case 1:
    _windowLength=value.toDouble();
    return true;
  case 2:
    _fitLength=value.toDouble();
    return true;
  default:
    break;
  }
  return AbstractParameters::setValue(index, value, unit, keywords);
}
