/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-09-02
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TOOLFACTORY_H
#define TOOLFACTORY_H

#include <GeopsyGui.h>

#define TOOLFACTORY_NPOPULAR 5

class ToolFactory : public QObject
{
  Q_OBJECT
public:
  ToolFactory(QObject * parent=nullptr);
  ~ToolFactory();

  void addActions(QWidget * w);
  bool addPopularActions(QMenu * menu, const QObject * receiver, const char * slot);
  void showTool(SubPoolWindow * win, QAction * a);

  QList<QAction *> createImportActions(QWidget * parent) const;
  void createPreferenceTabs(QTabWidget * tab);

  void setPreferences();
  void infoTools();

  void setHelp(ApplicationHelp * h);
  GeopsyGuiInterface * tool(QString pluginTag);
public slots:
  void showTool();
  void newGraphicWindow(QWidget * parent, const SubSignalPool& subPool);
private:
  QString action2Tag(QAction * a);
  QAction * tag2Action(QString tag);
  void addPopular(QAction * a);
  void showTool(SubPoolWindow * win, GeopsyGuiInterface * info, int slot);

  QList<GeopsyGuiInterface *> _list;
  QList<QAction *> _popular;
};

class ToolSeparator : public GeopsyGuiInterface
{
public:
  QString tag() const {return "separator";}
  QString title() const {return tr("--- Separator ---");}

  void createToolActions(QObject * toolFactory);
  QList<QAction *> createImportActions(QWidget * parent) const;
  AbstractToolWidget * createTool(int , QWidget *) const {return 0;}

  const char * interfaceVersion() const;
};


#endif // TOOLFACTORY_H
