/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-11-03
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef MAGNIFIERSIGNAL_H
#define MAGNIFIERSIGNAL_H

#include "GraphicWindow.h"

class MagnifierSignal :  public GraphicWindow
{
public:
  MagnifierSignal(QWidget* parent=0);

  void setSignal(SubSignalPool * parentSubPool, Signal * sig);
  void setTime(double t);
  void setContext(int c) {_context=c;}
  virtual void setWindowTitle(QString title);
protected:
  virtual void resizeEvent(QResizeEvent * );
  virtual void closeEvent(QCloseEvent * e);
private:
  ParallelBands * _cursorLayer;
  int _context;
};

#endif
