/***************************************************************************
**
**  This file is part of geopsy.
**
**  geopsy is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  geopsy is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-08-25
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef GROUPPROPERTIES_H
#define GROUPPROPERTIES_H

#include <GeopsyCore.h>
#include <QGpGuiTools.h>
#include "ui_GroupProperties.h"

class HeaderParser;

class GroupProperties : public PropertyWidget, private Ui::GroupProperties
{
  Q_OBJECT
public:
  GroupProperties(QWidget * parent=nullptr);

  enum Properties {Name, Comments, Folder};

  void removeMultiGroup();
  void setDatabase(SignalDatabase * db);
  void setValues(QList<AbstractSignalGroup *> gList);
  void setProperties(AbstractSignalGroup * g);
  AbstractSignalGroup * folder();
  bool isMultiGroupKey();
  bool isMultiGroupArray();
  MetaDataIndex splitKey();
  void setNameFromHistory();
public slots:
  void on_folderTree_clicked(const QModelIndex & index);
  void on_multiGroupBox_toggled(bool on);
  void on_multiGroupKey_currentIndexChanged(int);
  void on_multiGroupKeyButton_toggled(bool checked);
private:
  void checkValues(AbstractSignalGroup * g);
};

#endif // GROUPPROPERTIES_H
