/***************************************************************************
**
**  This file is part of dinvermatlab.
**
**  This file is distributed under the terms of the Geopsy.org Commercial
**  License appearing in the file LICENSE.COMMERCIAL included in the packaging
**  of this file.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See Geopsy.org Commercial License for
**  more details.
**
**  You should have received a copy of the Geopsy.org Commercial License
**  along with this program. If not, see <http://www.geopsy.org>.
**
**  See http://www.geopsy.org for more information.
**
**  Created : 2008-11-23
**  Authors :
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "MatlabTargetWidget.h"
#include "MatlabTarget.h"

/*!
  \class MatlabTargetWidget MatlabTargetWidget.h
  \brief Brief description of class still missing

  Full description of class still missing
*/

/*!
  Description of constructor still missing
*/
MatlabTargetWidget::MatlabTargetWidget(QWidget * parent)
    : QWidget(parent)
{
  TRACE;
  setupUi(this);
}

/*!
  Description of destructor still missing
*/
MatlabTargetWidget::~MatlabTargetWidget()
{
  TRACE;
}

MatlabTarget * MatlabTargetWidget::target()
{
  TRACE;
  MatlabTarget * s=new MatlabTarget;
  s->setStartup(startupEdit->text());
  s->setScriptPath(scriptPathEdit->text());
  s->setInitScript(initScriptEdit->text());
  s->setForwardScript(forwardScriptEdit->text());
  return s;
}

void MatlabTargetWidget::setFrom(MatlabTarget * target)
{
  TRACE;
  startupEdit->setText(target->startup());
  scriptPathEdit->setText(target->scriptPath());
  initScriptEdit->setText(target->initScript());
  forwardScriptEdit->setText(target->forwardScript());
}

void MatlabTargetWidget::setEditable(bool e)
{
  TRACE;
  startupEdit->setReadOnly( !e);
  scriptPathEdit->setReadOnly( !e);
  initScriptEdit->setReadOnly( !e);
  forwardScriptEdit->setReadOnly( !e);
}
