/***************************************************************************
**
**  This file is part of dinverdc.
**
**  dinverdc is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinverdc is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-10-31
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef PARAMGROUNDMODELWIDGET_H
#define PARAMGROUNDMODELWIDGET_H

#include <QGpGuiWave.h>
#include <DinverCore.h>
#include <DinverDCCore.h>
#include <DinverGui.h>

class ParamProfileWidget;

class ParamGroundModelWidget : public QWidget
{
  Q_OBJECT
public:
  ParamGroundModelWidget(QWidget *parent=nullptr, Qt::WindowFlags f=Qt::Widget);
  ~ParamGroundModelWidget();

  QSplitter * profileGeometry;
  QScrollArea * modelSheet;
  QVBoxLayout * vboxLayout;
  ParamSpaceEditor * customConditions;

  ParamProfileWidget * newProfile();
  ParamGroundModel * paramGroundModel();
  ParamProfileWidget * find(QString shortName);

  void setEditable(bool e);
public slots:
  void updateSize();
  void setDHLinks();
  void setFrom(ParamGroundModel * gm);
  void clear();
  void save();
  void save(QString fileName);
  void load();
  void load(QString fileName);
private slots:
  void checkCustomConditions();
protected:
  virtual void showEvent(QShowEvent * e);
};

#endif // PARAMGROUNDMODELWIDGET_H
