/***************************************************************************
**
**  This file is part of dinverdc.
**
**  dinverdc is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinverdc is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2005-11-05
**  Copyright: 2005-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef DINVERDCPLUGIN_H
#define DINVERDCPLUGIN_H

#include <DinverDCGui.h>

class ParamGroundModelWidget;
class TargetListWidget;

class DCPlugin: public DinverInterface
{
  Q_OBJECT
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
  Q_PLUGIN_METADATA(IID "org.geopsy.dinverInterface")
#endif
  Q_INTERFACES(DinverCore::DinverInterface)
public:
  DCPlugin();
  ~DCPlugin();

  DinverInterface * clone();

  QString tag() const;
  QString title() const ;
  QString version() const ;
  QString description() const ;

  QWidget * createTargetWidget();
  QWidget * createParamWidget();

  bool xmlSupport() const {return true;}
  void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
  XMLMember xml_member(XML_MEMBER_ARGS);
  bool xml_polishChild(XML_POLISHCHILD_ARGS);

  void addViewMenu(QMenu * m);
  void clear();

  AbstractForward * createForward();
  bool initForward(AbstractForward * forward);
  void setCurrentForward(AbstractForward * forwards, const QString& caption);

  const char * interfaceVersion() const;
public slots:
  void setParamFromTargets();
  void groundProfilesViewer();
  void dispersionViewer();
  void autocorrViewer();
  void ellipticityViewer();
  void refractionVpViewer();
  void refractionVsViewer();
  void magnetoTelluricViewer();
  void setCurrentGroundModel(ParamGroundModel * gm);
private:
  static QList<const TargetList *> targets(QList<const AbstractForward *> fl);
  static QWidget * parentWidget(QObject * o);
  static void setTargets(DCModelViewer * w, QWidget * mw, const QStringList& reports);

  // Gui definition of parameters and target
  ParamGroundModelWidget * _paramWidget;
  TargetListWidget * _targetWidget;
  // Global and batch definition of parameters and target
  // Null when global selection is active
  ParamGroundModel * _param;
  TargetList * _target;
};

#endif // DINVERDCPLUGIN_H
