/***************************************************************************
**
**  This file is part of dinver.
**
**  dinver is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  dinver is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-09-17
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef MODELSELECTOR_H
#define MODELSELECTOR_H

#include <QtWidgets>

#include "InversionThread.h"

class ModelSelector : public QDialog
{
  Q_OBJECT
public:
  ModelSelector(QWidget * parent=0, Qt::WindowFlags f=Qt::Widget);
  ~ModelSelector();

  void setParameterList(const InversionThread * t);
private slots:
  void sliderChanged(int value);
  void widthChanged(double);
signals:
  void setRange(int paramIndex, double min, double max);
  void setMaximumIndex(int index);
  void setMinimumIndex(int index);
private:
  void setRange(int paramIndex);

  const InversionThread * _thread;
};

#endif // MODELSELECTOR_H

