/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-12-01
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "Pen.h"

namespace SciFigs {

const QString Pen::xmlPenTag="Pen";
const Pen Pen::null;

void Pen::xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const
{
  TRACE;
  Q_UNUSED(context)
  writeProperty(s, "color",color().name());
  writeProperty(s, "width",_width);
  writeProperty(s, "style",styleName(style()));
  writeProperty(s, "capStyle",capStyleName(capStyle()));
  writeProperty(s, "joinStyle",joinStyleName(joinStyle()));
}

XMLMember Pen::xml_member(XML_MEMBER_ARGS)
{
  TRACE;
  Q_UNUSED(attributes)
  Q_UNUSED(context)
  if(tag=="color") return XMLMember(0);
  else if(tag=="style") return XMLMember(1);
  else if(tag=="capStyle") return XMLMember(2);
  else if(tag=="joinStyle") return XMLMember(3);
  else if(tag=="width") return XMLMember(4);
  return XMLMember(XMLMember::Unknown);
}

bool Pen::xml_setProperty(XML_SETPROPERTY_ARGS)
{
  TRACE;
  Q_UNUSED(tag)
  Q_UNUSED(attributes)
  Q_UNUSED(context)
  switch(memberID) {
  case 0: {
      QColor col(content.toString());
      setColor(col);
      return true;
    }
  case 1:
    setStyle(styleValue(content.toString()));
    return true;
  case 2:
    setCapStyle(capStyleValue(content.toString()));
    return true;
  case 3:
    setJoinStyle(joinStyleValue(content.toString()));
    return true;
  case 4:
    _width=content.toDouble();
    return true;
  default:
    return false;
  }
}

Qt::PenStyle Pen::styleValue(QString s)
{
  if(s=="SolidLine") return Qt::SolidLine;
  else if(s=="DashLine") return Qt::DashLine;
  else if(s=="DotLine") return Qt::DotLine;
  else if(s=="DashDotLine") return Qt::DashDotLine;
  else if(s=="DashDotDotLine") return Qt::DashDotDotLine;
  else return Qt::NoPen;
}

QString Pen::styleName(Qt::PenStyle s)
{
  TRACE;
  switch (s) {
  case Qt::SolidLine: return "SolidLine";
  case Qt::DashLine: return "DashLine";
  case Qt::DotLine: return "DotLine";
  case Qt::DashDotLine: return "DashDotLine";
  case Qt::DashDotDotLine: return "DashDotDotLine";
  default: return "NoPen";
  }
}

Qt::PenCapStyle Pen::capStyleValue(QString s)
{
  if(s=="SquareCap") return Qt::SquareCap;
  else if(s=="RoundCap") return Qt::RoundCap;
  else return Qt::FlatCap;
}

QString Pen::capStyleName(Qt::PenCapStyle s)
{
  TRACE;
  switch (s) {
  case Qt::SquareCap: return "SquareCap";
  case Qt::RoundCap: return "RoundCap"; 
  default: return "FlatCap";
  }
}

Qt::PenJoinStyle Pen::joinStyleValue(QString s)
{
  if(s=="BevelJoin") return Qt::BevelJoin;
  else if(s=="RoundJoin") return Qt::RoundJoin; 
  else return Qt::MiterJoin;
}

QString Pen::joinStyleName(Qt::PenJoinStyle s)
{
  TRACE;
  switch (s) {
  case Qt::BevelJoin: return "BevelJoin";
  case Qt::RoundJoin: return "RoundJoin"; 
  default: return "MiterJoin";  
  }
}

/*QTextStream& operator>>(QTextStream& s,Pen& p)
{
  QString str=s.readLine().trimmed();
  bool ok;
  int r=str.section(" ",0,0).toInt(&ok);
  if(!ok) goto error;
  int g=str.section(" ",1,1).toInt(&ok);
  if(!ok) goto error;
  int b=str.section(" ",2,2).toInt(&ok);
  if(!ok) goto error;
  p.setColor(QColor(r,g,b));
  int val=str.section(" ",3,3).toInt(&ok);
  if(!ok) goto error;
  p.setWidth(val*0.295);
  val=str.section(" ",4,4).toInt(&ok);
  if(!ok) goto error;
  p.setStyle((Qt::PenStyle)val);
  val=str.section(" ",5,5).toInt(&ok);
  if(!ok) goto error;
  p.setCapStyle((Qt::PenCapStyle)val);
  val=str.section(" ",6,6).toInt(&ok);
  if(!ok) goto error;
  p.setJoinStyle((Qt::PenJoinStyle)val);
  return s;
error:
  Message::wrongTextFormat(s, translate("Pen", "Restoring pen"));
  return s;
}*/

} // namespace SciFigs
