/***************************************************************************
**
**  This file is part of SciFigs.
**
**  SciFigs is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  SciFigs is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-05-04
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef GRAPHICOBJECTGROUP_H
#define GRAPHICOBJECTGROUP_H

#include "GraphicObject.h"
#include "GraphicObjectList.h"
#include "SciFigsDLLExport.h"

namespace SciFigs {

  class SCIFIGS_EXPORT GraphicObjectGroup : public GraphicObject
  {
    Q_OBJECT
  public:
    GraphicObjectGroup(QWidget * parent=nullptr);
    ~GraphicObjectGroup();

    const QString& xml_tagName() const {return xmlGroupTag;}
    static const QString xmlGroupTag;

    void setSheet(GraphicSheet * s);

    void addObject(GraphicObject * obj);
    GraphicObjectList objects() const {return findChildren<GraphicObject>();}

    void addProperties(PropertyProxy * pp);
    void removeProperties(PropertyProxy * pp);

    void scaleFonts(FontScales& orignal, double scale);
    void restoreScaleFonts(const FontScales& orignal);
    void print(QPainter& p, double dotpercm, int x0Sheet, int y0Sheet, bool mask);

  public slots:
    void deepUpdate();
    void resize();
  protected:
    template <typename T> inline QList<T *> findChildren() const;
    void addActions();
    void connectObject(GraphicObject * obj);

    void xml_writeChildren(XML_WRITECHILDREN_ARGS) const;
    XMLMember xml_member(XML_MEMBER_ARGS);
    bool xml_polish(XML_POLISH_ARGS);
  };

  template <typename T>
  inline QList<T *> GraphicObjectGroup::findChildren() const
  {
    return QWidget::findChildren<T *>(QString(), Qt::FindDirectChildrenOnly);
  }

} // namespace SciFigs

#endif // GRAPHICOBJECTGROUP_H

