/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-12-01
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef BRUSH_H
#define BRUSH_H

#include <QtGui>
#include <QGpCoreTools.h>
#include "SciFigsDLLExport.h"

namespace SciFigs {

class SCIFIGS_EXPORT Brush : public QBrush, public XMLClass
{
public:
  Brush() {}
  Brush(Qt::BrushStyle style) : QBrush(style) {}
  Brush(const QColor & color, Qt::BrushStyle style=Qt::SolidPattern)
    : QBrush(color, style) {}
  Brush(const QImage& image)
    : QBrush(image) {}
  Brush(const QBrush & b) : QBrush(b) {}
  virtual ~Brush() {}

  virtual const QString& xml_tagName() const {return xmlBrushTag;}
  static const QString xmlBrushTag;

  static QString styleName(Qt::BrushStyle);
  static Qt::BrushStyle styleValue(QString s);

  QBrush qbrush(double dotpercm) const;
protected:
  virtual void xml_writeProperties(XML_WRITEPROPERTIES_ARGS) const;
  virtual bool xml_setProperty(XML_SETPROPERTY_ARGS);
  virtual XMLMember xml_member(XML_MEMBER_ARGS);
};
  
} // namespace SciFigs

#endif // BRUSH_H
