/***************************************************************************
**
**  This file is part of SciFigs.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-02-06
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef TABAUTOADJUSTSCALEPROPERTIES_H
#define TABAUTOADJUSTSCALEPROPERTIES_H

#include <QGpGuiTools.h>

#include "ui_AutoAdjustScaleProperties.h"

namespace SciFigs {

  class AutoAdjustScale;

  class AutoAdjustScaleProperties : public PropertyWidget, private Ui::AutoAdjustScaleProperties
  {
    Q_OBJECT
  public:
    AutoAdjustScaleProperties(QWidget * parent=nullptr);

    enum Properties {AutoAdjust, LinearScale, LogScale,
                     ForceMinValue, MinValue,
                     ForceMaxValue, MaxValue,
                     ForceRatio, Ratio,
                     Symetric};

  private slots:
    void on_linearScale_toggled(bool c);
    void on_forceMinValue_toggled(bool c);
    void on_forceMaxValue_toggled(bool c);
    void on_forceRatio_toggled(bool c);
  };

} // namespace SciFigs

#endif // AUTOADJUSTSCALEPROPERTIES_H
