/***************************************************************************
**
**  This file is part of QGpGuiWave.
**
**  QGpGuiWave is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpGuiWave is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2015-02-24
**  Copyright: 2015-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreWave.h>

#include "ModalCurveProperties.h"
#include "ModeSelector.h"
#include "ModeItem.h"

namespace QGpGuiWave {

  /*!
    \class ModalCurveProperties ModalCurveProperties.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  /*!
    Description of constructor still missing
  */
  ModalCurveProperties::ModalCurveProperties(QWidget * parent)
    : CurveProperties(parent)
  {
    TRACE;
    QVBoxLayout * vboxLayout=qobject_cast<QVBoxLayout *>(layout());
    ASSERT(vboxLayout);

    vboxLayout->removeWidget(curveTable);
    _msSplitter=new QSplitter;
    _msSplitter->setObjectName("modeSplitter");
    _msSplitter->setOrientation(Qt::Vertical);
    _modes=new ModeSelector;
    _modes->setObjectName("modeSelector");
    _msSplitter->addWidget(_modes);
    _msSplitter->addWidget(curveTable);
    vboxLayout->insertWidget(0, _msSplitter);

    visibleBut->setToolTip(tr("Only visible curves are used for misfit computation"));
  }

  /*!
    Description of destructor still missing
  */
  ModalCurveProperties::~ModalCurveProperties()
  {
    TRACE;
    Settings::setSplitter(_msSplitter, proxy()->tag());
  }

  void ModalCurveProperties::setProxy(CurveProxy * proxy)
  {
    ModalProxy * modalProxy=static_cast<ModalProxy *>(proxy);
    CurveProperties::setProxy(modalProxy);
    _modes->setProxy(modalProxy);
    Settings::splitter(_msSplitter, proxy->tag());
  }

  void ModalCurveProperties::setModeType(Mode::Type t)
  {
    TRACE;
    _modes->setModeType(t);
  }

  void ModalCurveProperties::setDefaultModeIndex(int i)
  {
    TRACE;
    _modes->setDefaultModeIndex(i);
  }

  void ModalCurveProperties::setDefaultRingIndex(int i)
  {
    TRACE;
    _modes->setDefaultRingIndex(i);
  }

  Mode ModalCurveProperties::defaultMode() const
  {
    TRACE;
    return _modes->defaultMode();
  }

  void ModalCurveProperties::setEditable(bool e)
  {
    TRACE;
    CurveProperties::setEditable(e);
    _modes->setEditable(e);
    visibleBut->setEnabled(e);
  }

  void ModalCurveProperties::beginCurveChange()
  {
    TRACE;
    CurveProperties::beginCurveChange();
    _modes->beginModeChange();
  }

  void ModalCurveProperties::endCurveChange()
  {
    TRACE;
    _modes->endModeChange();
    CurveProperties::endCurveChange();
  }

} // namespace QGpGuiWave
