/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-09-13
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>

#include "WidgetRect.h"

namespace QGpGuiTools {

  /*!
    \class WidgetRect WidgetRect.h
    \brief Brief description of class still missing

    When a widget box is not visible on the screen, it is not possible to retrieve its correct rectangle and
    state (maximized, minimized,...). This class dynamically store the rectangle while the widget box is visible
    and save it to registry upon request.
  */

  void WidgetRect::record(QWidget * w)
  {
    TRACE;
    if(w->isVisible()) {
      if(_lock==0) {
        _rect.setTopLeft(w->pos());  // Never touch the bottom-right corner
                                     // So, it may change the size and even generate a negative size.
                                     // 20161205: fix the order of setTopLeft and setSize to avoid
                                     //            negative sizes
        _rect.setSize(w->size());
        _valid=true;
      } else {
        _lock--;
      }
    }
  }

  void WidgetRect::saveRect(QWidget * w, QString name)
  {
    TRACE;
    if(_valid) {
      QSettings& reg=CoreApplication::instance()->settings();
      reg.beginGroup("WidgetRect");
      reg.beginGroup(name.isEmpty() ? w->objectName() : name);
      reg.setValue("x", _rect.x());
      reg.setValue("y", _rect.y());
      if(w->isMaximized()) {
        reg.setValue("width", -1);
        reg.setValue("height", -1);
      } else {
        reg.setValue("width", _rect.width());
        reg.setValue("height", _rect.height());
      }
    }
  }

} // namespace QGpGuiTools

