/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-12-04
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include <QPrintDialog>

#include "PrintDialogWrapper.h"

namespace QGpGuiTools {

/*!
  \class PrintDialogWrapper PrintDialogWrapper.h
  \brief Brief description of class still missing

  Current interface for QPrintDialog is rather poor. This class tries to improve it in a relatively ugly way.
  But there is not other choice, all is private in QPrintDialog
*/

/*!
  Description of constructor still missing
*/
PrintDialogWrapper::PrintDialogWrapper(QPrintDialog * parent)
    : QObject(parent)
{
  TRACE;
  _btnBrowse=parent->findChild<QPushButton *>("btnBrowse");
  _leFile=parent->findChild<QLineEdit *>("leFile");
  if(_btnBrowse && _leFile) {
    _btnBrowse->disconnect(SIGNAL(clicked()));
    connect(_btnBrowse, SIGNAL(clicked()), this, SLOT(browse()));
  }
  _chbPrintToFile=parent->findChild<QCheckBox *>("chbPrintToFile");
  // Force toggle
  if(_chbPrintToFile) {
    bool b=_chbPrintToFile->isChecked();
    _chbPrintToFile->setChecked(!b);
    _chbPrintToFile->setChecked(b);
  }
}

/*!
  Browse in another way
*/
void PrintDialogWrapper::browse()
{
  TRACE;
  QString fileName=Message::getSaveFileName(tr("Print to file"), tr("Postcript files (*.ps);;PDF files (*.pdf)"));
  if(!fileName.isEmpty() && _leFile) {
    _leFile->setText(fileName);
  }
}

} // namespace QGpGuiTools
