/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2006-04-04
**  Copyright: 2006-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "MessageBox.h"

namespace QGpGuiTools {

MessageBox::MessageBox(QWidget * parent)
    : Dialog(parent)
{
  TRACE;
  setupUi(this);
  _answer=Message::Answer0;
  _buttons[0]=0;
  _buttons[1]=0;
  _buttons[2]=0;
  again=0;
}

void MessageBox::setMessage(QString t)
{
  TRACE;
  if(t.startsWith("<html>")) {
    message->setHtml(t);
  } else {
    message->setPlainText(t);
  }
}

QDialogButtonBox::StandardButton qtStandardButton(QString but)
{
  if(but==tr("OK")) {
    return QDialogButtonBox::Ok;
  }
  if(but==tr("Cancel")) {
    return QDialogButtonBox::Cancel;
  }
  if(but==tr("Yes")) {
    return QDialogButtonBox::Yes;
  }
  if(but==tr("No")) {
    return QDialogButtonBox::No;
  }
  if(but==tr("Close")) {
    return QDialogButtonBox::Close;
  }
  if(but==tr("Ignore")) {
    return QDialogButtonBox::Ignore;
  }
  return QDialogButtonBox::NoButton;
}

void MessageBox::setButton(int index, QString but)
{
  TRACE;
  if(!but.isEmpty()) {
    QDialogButtonBox::StandardButton qtBut=qtStandardButton(but);
    if(qtBut!=QDialogButtonBox::NoButton) {
      _buttons[index]=buttons->addButton(qtStandardButton(but));
    } else {
      _buttons[index]=buttons->addButton(but, QDialogButtonBox::AcceptRole);
    }
    if(index==0) _buttons[index]->setDefault(true);
  } else if(index==0) {
    _buttons[index]=buttons->addButton(QDialogButtonBox::Ok);
    _buttons[index]->setDefault(true);
  }
}

void MessageBox::setSeverity(Message::Severity sev)
{
  TRACE;
  switch (sev) {
  case Message::Information:
    iconLabel->setPixmap(QMessageBox::standardIcon(QMessageBox::Information));
    break;
  case Message::Warning:
    iconLabel->setPixmap(QMessageBox::standardIcon(QMessageBox::Warning));
    break;
  case Message::Critical:
  case Message::Fatal:
    iconLabel->setPixmap(QMessageBox::standardIcon(QMessageBox::Critical));
    break;
  case Message::Question:
    iconLabel->setPixmap(QMessageBox::standardIcon(QMessageBox::Question));
    break;
  }
}

void MessageBox::addAgainOption()
{
  TRACE;
  QHBoxLayout * hboxLayout=new QHBoxLayout();
  hboxLayout->setSpacing(6);
  hboxLayout->setMargin(0);
  hboxLayout->addItem(new QSpacerItem(93, 20, QSizePolicy::Expanding, QSizePolicy::Minimum));
  again=new QCheckBox(this);
  again->setText(tr("Show this message again"));
  again->setChecked(true);
  hboxLayout->addWidget(again);
  hboxLayout->addItem(new QSpacerItem(93, 20, QSizePolicy::Expanding, QSizePolicy::Minimum));
  QVBoxLayout * vboxLayout=qobject_cast<QVBoxLayout *>(layout());
  ASSERT(vboxLayout);
  vboxLayout->addLayout(hboxLayout);
}

void MessageBox::on_buttons_clicked(QAbstractButton * but)
{
  TRACE;
  if(but==_buttons[0]) {
    _answer=Message::Answer0;
  } else if(but==_buttons[1]) {
    _answer=Message::Answer1;
  } else if(but==_buttons[2]) {
    _answer=Message::Answer2;
  }
  accept();
}

bool MessageBox::showAgain()
{
  TRACE;
  return again->isChecked();
}

} // namespace QGpGuiTools
