/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2013-02-14
**  Copyright: 2013-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#include <QGpCoreTools.h>

#include "ColumnTextDelegate.h"

namespace QGpGuiTools {

  /*!
    \class ColumnTextDelegate ColumnTextDelegate.h
    \brief Brief description of class still missing

    Full description of class still missing
  */

  QWidget * ColumnTextDelegate::createEditor(QWidget * parent, const QStyleOptionViewItem &,
                                             const QModelIndex & index) const
  {
    TRACE;
    switch (index.row()) {
    case 0: {
        QComboBox * w=new QComboBox(parent);
        w->addItems(_types);
        connect(w, SIGNAL(activated(int)), this, SLOT(typeChanged()));
        return w;
      }
    case 1:
    case 2:
    case 3: {
        QLineEdit * w=new QLineEdit(parent);
        return w;
      }
    default:
      return 0;
    }
    return 0;
  }

  void ColumnTextDelegate::setEditorData(QWidget *editor, const QModelIndex &index) const
  {
    TRACE;
    switch (index.row()) {
    case 0: {
        QComboBox * w=qobject_cast<QComboBox *>(editor);
        ASSERT(w);
        int i=w->findText(index.model()->data(index).toString());
        w->setCurrentIndex(i);
        break;
      }
    case 1:
    case 2:
    case 3: {
        QLineEdit * w=qobject_cast<QLineEdit *>(editor);
        ASSERT(w);
        w->setText(index.model()->data(index).toString());
        w->selectAll();
        break;
      }
    default:
      break;
    }
  }

  void ColumnTextDelegate::setModelData(QWidget *editor, QAbstractItemModel *model,
                                        const QModelIndex &index) const
  {
    TRACE;
    switch (index.row()) {
    case 0: {
        QComboBox * w=qobject_cast<QComboBox *>(editor);
        ASSERT(w);
        if(model->data(index)!=w->currentText()) {
          model->setData(index, w->currentText());
        }
        break;
      }
    case 1:
    case 2:
    case 3: {
        QLineEdit * w=qobject_cast<QLineEdit *>(editor);
        ASSERT(w);
        if(model->data(index)!=w->text()) {
          model->setData(index, w->text());
        }
        break;
      }
    default:
      break;
    }
  }

  void ColumnTextDelegate::typeChanged()
  {
    TRACE;
    QComboBox * w=qobject_cast<QComboBox *>(sender());
    ASSERT(w);
    emit commitData(w);
  }

} // namespace QGpGuiTools
