/***************************************************************************
**
**  This file is part of QGpGuiTools.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2003-10-23
**  Copyright: 2003-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COLORHISTOGRAM_H
#define COLORHISTOGRAM_H

#include <QtGui>
#if(QT_VERSION > QT_VERSION_CHECK(5, 0, 0))
#include <QtWidgets>
#endif

#include <QGpCoreTools.h>

#include "QGpGuiToolsDLLExport.h"

namespace QGpGuiTools {

#define TEXT_WIDTH 50
#define COLOR_WIDTH 50
#define COLOR_HEIGHT 15

class QGPGUITOOLS_EXPORT ColorHistogram : public QWidget
{
  Q_OBJECT
public:
  ColorHistogram(QRgb * colors, int * values, int num, QWidget *parent=nullptr);
  ~ColorHistogram();
  void resizeEvent(QResizeEvent * e);
  void paintEvent(QPaintEvent * e);
protected:
  QScrollBar sBar;
  int _numColors;
  int * _values;
  QRgb * _colors;
  int _maxVal;
public slots:
  void scrollChanged(int);
};

} // namespace QGpGuiTools

#endif // COLORHISTOGRAM_H
