/***************************************************************************
**
**  This file is part of QGpGuiMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2008-09-16
**  Copyright: 2008-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COORDINATEFILEWIDGET_H
#define COORDINATEFILEWIDGET_H

#include <QGpGuiTools.h>
#include <QGpCoreMath.h>

#include "ui_CoordinateFileWidget.h"
#include "QGpGuiMathDLLExport.h"

namespace QGpGuiMath {

  class QGPGUIMATH_EXPORT CoordinateFileWidget: public Dialog, private Ui::CoordinateFileWidget
  {
    Q_OBJECT
  public:
    CoordinateFileWidget(QWidget * parent=nullptr);
    ~CoordinateFileWidget();

    bool read(QString fileName=QString(), const QString &format=QString());
    static bool write(const QList<NamedPoint>& points, const UtmZone& utmZone, QString fileName=QString());

    QString fileName() const;

    bool contains(const QString& name) const;
    QList<NamedPoint> points() const {return _points;}

    const UtmZone& utmZone() const {return _utmZone;}
  private slots:
    void enableConversion();
    void copyPointToReference();
    void copyReference();
    void beforeLeaving();
  private:
    CoordinateFile * fileEngine() const;
    void setPoints();
    void convert(CoordinateConvert::Projection p, const Point2D& reference);

    QList<NamedPoint> _points;
    UtmZone _utmZone;
  };

} // namespace QGpGuiMath

#endif // COORDINATEFILEWIDGET_H
