/***************************************************************************
**
**  This file is part of QGpCoreWave.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2010-06-15
**  Copyright: 2010-2019
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "GeophysicalModel.h"
#include "Seismic1DModel.h"
#include "Resistivity1DModel.h"
#include "RefractionDippingModel.h"

namespace QGpCoreWave {

/*!
  \class GeophysicalModel GeophysicalModel.h
  \brief Abstract class for any geophysical model

  Provide a common interface for geophysical models
*/

  QString GeophysicalModel::allFormatHelp()
  {
    return "Format for seismic 1D layered models:\n"
           + Seismic1DModel::formatHelp() +
           "\n\n"
           "Format for refraction dipping layered models:\n"
           + RefractionDippingModel::formatHelp() +
           "\n\n"
           "Format for resistivity 1D layered models:\n"
           + Resistivity1DModel::formatHelp() +
           "\n\n";
  }

} // namespace QGpCoreWave
