/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-11-06
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef TRIANGULARMATRIX_H
#define TRIANGULARMATRIX_H

#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT TriangularMatrix
  {
  public:
    TriangularMatrix(int n);
    TriangularMatrix(const TriangularMatrix& o);
    ~TriangularMatrix();

    void operator=(const TriangularMatrix& o);

    int count() const {return _n;}
    int rowCount(int col) const {return col;}
    int columnCount(int row) const {return _n1-row;}

    inline double& at(int row, int col);
    inline double constAt(int row, int col) const;
    inline double constAt(int row, int col);

    void removeAt(int index);
    void random(double min=0.0, double max=1.0);

    QString toUserString(char format='g', int precision=6) const;
    QString toOctaveString(char format='g', int precision=6) const;
    QString toGridString() const;
    QString toString() const;
    bool fromString(const StringSection& s);
  private:
    int valueCount() const {return (_n*_n1) >> 1;}
    void setRows();

    int _n, _n1;
    double * _values;
    double ** _rows;
  };

  double& TriangularMatrix::at(int row, int col)
  {
    if(row<col) {
      return _rows[row][col];
    } else {
      ASSERT(col<row);
      return _rows[col][row];
    }
  }

  double TriangularMatrix::constAt(int row, int col) const
  {
    if(row<col) {
      return _rows[row][col];
    } else if(row>col) {
      return _rows[col][row];
    } else {
      return 0.0;
    }
  }

  inline double TriangularMatrix::constAt(int row, int col)
  {
    return const_cast<const TriangularMatrix *>(this)->constAt(row, col);
  }

} // namespace QGpCoreMath

#endif // TRIANGULARMATRIX_H

