/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2004-05-17
**  Copyright: 2004-2019
**    Marc Wathelet
**    Marc Wathelet (ULg, Liège, Belgium)
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#include "Matrix.h"

namespace QGpCoreMath {

  /*!
    \class Matrix Matrix.h

    Template for implicitely shared matrix compatible with Lapack

    LAPACK is assuming matrix stored in column vectors column

       For a MxN matrix:
          a(1,1) ... a(m,1) a(1,2) ... a(m,2)    ...   a(1,n) ... a(m,n)
          first column      second column              last column
  */

  /*!
    \fn Matrix<T> transposed() const

    Returns a new matrix, transposed of this.
  */

  /*!
    \fn void invert()

    Inverts this matrix.
  */

  /*!
    \fn void transpose()

    Transposes this matrix.
  */

  /*!
    \fn void mergeRow(const Matrix<T>& row1, const Matrix<T>& row2)

    Build this matrix with \a row1 on top of \a row2. The final total number of rows is
    the sum of rows from \a row1 and \a row2. The number of columns must be the same for
    \a row1 and \a row2
  */

  /*!
    \fn void mergeColumn(const Matrix<T>& col1, const Matrix<T>& col2)

    Build this matrix with \a col1 on the left of \a col2. The final total number of columns is
    the sum of columns from \a col1 and \a col2. The number of rows must be the same for
    \a col1 and \a col2
  */

  /*!
    \fn Matrix<T> subMatrix(int rowStart, int colStart, int rowEnd, int colEnd)

    Returns a sub-matrix from this between start and end rows and columns
  */

  /*!
    \fn Matrix<T> sortedRows(const QVector<int>& permutations)

    \a permutations vector must have the save size as the number of rows in this matrix.
    Each element i in the vector is the index of the row[i] in the sorted matrix, originately at i.
    A neutral permutation vector has elements: 0, 1, 2,...
  */

  /*!
    \fn Matrix<T> sortedColumns(const QVector<int>& permutations)

    \a permutations vector must have the save size as the number of columns in this matrix.
    Each element i in the vector is the index of the column[i] in the sorted matrix, originately at i.
    A neutral permutation vector has elements: 0, 1, 2,...
  */

  /*!
    \fn QVector<T> Matrix<T>::rowAt(int row) const

    Returns row \a row as a QVector.
  */

  /*!
    \fn QVector<T> Matrix<T>::columnAt(int col) const
    Returns column \a col as a QVector.
  */

} // namespace QGpCoreMath
