/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-05-25
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef GRIDPARALLELWRITER_H
#define GRIDPARALLELWRITER_H

#include "QGpCoreMathDLLExport.h"
#include "IrregularGrid2D.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT GridParallelWriter
  {
  public:
    GridParallelWriter(IrregularGrid2D * grid);
    ~GridParallelWriter();

    void lockRows();
    void lockColumns();

    inline double * lockRow(int index);
    inline double * lockColumn(int index);
    void unlock(int index) {_locks[index].unlock();}
  private:
    IrregularGrid2D * _grid;
    QMutex * _locks;
    int _lockCount;
  };

  inline double * GridParallelWriter::lockRow(int index)
  {
    _locks[index].lock();
    return _grid->valuePointer(0, index);
  }

  inline double * GridParallelWriter::lockColumn(int index)
  {
    _locks[index].lock();
    return _grid->valuePointer(index, index);
  }

} // namespace QGpCoreMath

#endif // GRIDPARALLELWRITER_H

