/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2009-04-11
**  Copyright: 2009-2019
**    Marc Wathelet
**    Marc Wathelet (LGIT, Grenoble, France)
**
***************************************************************************/

#ifndef COMPLEXEXPONENTIAL_H
#define COMPLEXEXPONENTIAL_H

#include <QGpCoreTools.h>

#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

class QGPCOREMATH_EXPORT ComplexExponential
{
public:
  enum Sign {Positive, Negative};
  ComplexExponential(int n, Sign s);
  ~ComplexExponential();

  inline const Complex& value(long int x);
private:
  Complex * _cache;
  Sign _s;
  int _n;
  double _invn;
};

inline const Complex& ComplexExponential::value(long int x)
{
  if(x>=_n) {
    x=x % _n;
  }
  Complex& c=_cache[x];
  if(c.isNull()) {
    switch (_s) {
    case Positive:
      c.setUnitExp(2 * M_PI * (double)x*_invn);
      break;
    case Negative:
      c.setUnitExp( -2 * M_PI * (double)x*_invn);
      break;
    }
  }
  return c;
}

} // namespace QGpCoreMath

#endif // COMPLEXEXPONENTIAL_H
