/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  This library is free software; you can redistribute it and/or
**  modify it under the terms of the GNU Lesser General Public
**  License as published by the Free Software Foundation; either
**  version 2.1 of the License, or (at your option) any later version.
**
**  This file is distributed in the hope that it will be useful, but WITHOUT
**  ANY WARRANTY; without even the implied warranty of MERCHANTABILITY or
**  FITNESS FOR A PARTICULAR PURPOSE. See the GNU Lesser General Public
**  License for more details.
**
**  You should have received a copy of the GNU Lesser General Public
**  License along with this library; if not, write to the Free Software
**  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301  USA
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2016-11-08
**  Copyright: 2016-2019
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef COLORPALETTE_H
#define COLORPALETTE_H

#include <QGpCoreTools.h>

#include "QGpCoreMathDLLExport.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT ColorPalette
  {
  public:
    ColorPalette();
    ColorPalette(const ColorPalette& o);
    ~ColorPalette();

    enum Model {McNames, McNamesClip, Hobi, Hsv, Sardine, ColdHot};

    void operator=(const ColorPalette& o);
    bool operator==(const ColorPalette& o) const;

    QString toString() const;
    bool fromString(const QString& s);

    void resize(int n);
    int count() const {return _n;}

    const Color& color(int index) const {return _colors[index];}
    Color& color(int index) {return _colors[index];}
    void setColor(int index, const Color& c) {_colors[index]=c;}

    void generateColorScale(int n, Model m, bool reversed=false, int transparency=255);
    void generateGrayScale(int n, Model m, bool reversed=false, int transparency=255);
    void setWhiteTransparent(bool b);

    void sardineColorScale(int n, int transparency=255);
    void sardineGrayScale(int n, int transparency=255);
    void hsv(int n, int sat=255, int value=255, int transparency=255);
    void mcNames(int n, int n0, int transparency=255);
    void hobi(int n, int transparency=255);
    void coldHot(int n, int transparency=255);

    void rgbInterpole(int imin, int imax);
    void hsvInterpole(int imin, int imax);

    void toGray();
    void reverse();

    static ColorPalette preference(const QString& name, int n, Model m);
    static void setPreference(const QString& name, const ColorPalette& pal);
  private:

    int _n;
    Color * _colors;
  };

} // namespace QGpCoreMath

#endif // COLORPALETTE_H

