/***************************************************************************
**
**  This file is part of QGpCoreMath.
**
**  QGpCoreMath is free software: you can redistribute it and/or modify
**  it under the terms of the GNU General Public License as published by
**  the Free Software Foundation, either version 3 of the License, or
**  (at your option) any later version.
**
**  QGpCoreMath is distributed in the hope that it will be useful,
**  but WITHOUT ANY WARRANTY; without even the implied warranty of
**  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
**  GNU General Public License for more details.
**
**  You should have received a copy of the GNU General Public License
**  along with Foobar.  If not, see <http://www.gnu.org/licenses/>
**
**  See http://www.geopsy.org for more information.
**
**  Created: 2020-11-05
**  Copyright: 2020
**    Marc Wathelet (ISTerre, Grenoble, France)
**
***************************************************************************/

#ifndef CLUSTER_H
#define CLUSTER_H

#include "QGpCoreMathDLLExport.h"
#include "TriangularMatrix.h"

namespace QGpCoreMath {

  class QGPCOREMATH_EXPORT Cluster
  {
  public:
    Cluster(const TriangularMatrix& proximity);
    ~Cluster();

    class Node: public TreeContainer
    {
    public:
      QVector<int> indexList() const;
      QString toString(int countMax=INT_MAX) const;
    };

    class Item : public TreeItem
    {
    public:
      Item(int index) : TreeItem(), _index(index) {}

      int index() const {return _index;}

      void xml_attributes(XML_ATTRIBUTES_ARGS) const;
    private:
      int _index;
    };

    Node * singleLinkage();

    static void test(const TriangularMatrix& proximity);
    static TriangularMatrix singleLinkageTest();
  private:
    QVector<QPoint> minima();
    void removeProximity(int row, int col);
    void mergeReport(int row, int col) const;

    TriangularMatrix _proximity;
    QVector<TreeItem *> _items;
  };

} // namespace QGpCoreMath

#endif // CLUSTER_H

